<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package     block_trackerclass
 * @copyright   2019 Jose Gomez <info@escueladidactica.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/*
* Esta clase se encarga de renderizar formulario del bloque,
* hacer validaciones y consultas necesarias para el buen
* funcionamiento de la solucion "ver Certificados".
*/

require_once("../../../config.php");
require_once($CFG->libdir . '/excellib.class.php'); //Libreria de excel

global $PAGE, $CFG;

$course_id = $_REQUEST['courseid'];
$id_programacion = $_REQUEST['id_programacion'];

$name_informe = "Informe";

$title_username = get_string('label_header_identification', 'block_trackerclass');
$title_fullname = get_string('label_header_fullname', 'block_trackerclass');
$title_dedication = get_string('label_header_dedication', 'block_trackerclass');
$title_final_grade = get_string('label_table_finalgrade', 'block_trackerclass');

$txt_present = get_string('label_table_present', 'block_trackerclass');
$txt_nopresent = get_string('label_table_nopresent', 'block_trackerclass');

$course = $DB->get_record('course',['id'=>$course_id]);
$date_programacion = $DB->get_record('trackerclass_programacion',['id'=>$id_programacion]);
$date = date("Y-m-d",$date_programacion->date);
$downloadfilename = clean_filename($date."_".$course->fullname); //Nombre del archivo .xls
$ExcelBook = new MoodleExcelWorkbook("-");
$ExcelBook->send($downloadfilename);

/*
* INFORME
*/
$hoja = $ExcelBook->add_worksheet($name_informe);
$hoja->write_string(0,0,"");
$hoja->write_string(1,1,"N°"); // $n
$hoja->write_string(1,2,$title_username); //username
$hoja->write_string(1,3,$title_fullname); //fullname
$hoja->write_string(1,4,$title_dedication); //dedication - column = 4


/* HEADERS PARA DEDICACION Y CUMPLIMIENTO */
$sql = "SELECT id,itemname, sortorder FROM mdl_trackerclass_reportes WHERE id_programacion = ".$id_programacion." AND type = 'status' AND itemname NOT IN ('dedication', 'final grade') GROUP BY sortorder ORDER BY sortorder";
$sql = str_replace('mdl_', $CFG->prefix, $sql);

$headers = $DB->get_records_sql($sql);
$column = 5;
$last_column = count($headers)+$column-1;
$hoja->merge_cells(0, $column, 0, $last_column);
$hoja->write_string(0,$column, 'CUMPLIMIENTO DE ACTIVIDADES');
foreach ($headers as $header) {
    $hoja->write_string(1,$column,$header->itemname);
    $column++;     
}

/* HEADERS PARA CALIFICACIONES */
$sql0 = "SELECT id,itemname, sortorder FROM mdl_trackerclass_reportes WHERE id_programacion = ".$id_programacion." AND type = 'grade' AND itemname NOT IN ('dedication') GROUP BY sortorder ORDER BY sortorder";
$sql0 = str_replace('mdl_', $CFG->prefix, $sql0);

$headers = $DB->get_records_sql($sql0);
$last_column = count($headers)+$last_column;
$hoja->merge_cells(0, $column, 0, $last_column);
$hoja->write_string(0,$column, 'CALIFICACIONES');
foreach ($headers as $header) {
    if($header->itemname == 'final grade'){
        $hoja->write_string(1,$column, $title_final_grade);
    }
    else{
        $hoja->write_string(1,$column,$header->itemname);
    }
    $column++;    
}

/* DEDICATION AL CURSO */
$sql1 = "SELECT * FROM mdl_trackerclass_reportes WHERE id_programacion = ".$id_programacion." AND type = 'dedication' ORDER BY sortorder";
$sql1 = str_replace('mdl_', $CFG->prefix, $sql1);

$dedicaciones = $DB->get_records_sql($sql1);
$row = 2;
$n = 1;
foreach ($dedicaciones as $key => $dedicacion) {
	$hoja->write_number($row,1,$n);

    /* USER INFO */
	$user_info = $DB->get_record("user", ['id'=>$dedicacion->userid]);

    if(!empty($user_info)){
        $username = $user_info->username;
        $fullname = $user_info->firstname." ".$user_info->lastname;
        $hoja->write_string($row,2,$username);
        $hoja->write_string($row,3,$fullname);
    }

	$dedication_time = format_dedication($dedicacion->value);
	$hoja->write_string($row,4,$dedication_time);
	
    /* CUMPLIMIENTO */
    $sql2 = "SELECT * 
            FROM 
                mdl_trackerclass_reportes 
            WHERE 
                userid = {$dedicacion->userid} AND
                id_programacion = {$id_programacion} AND
                type = 'status'";

    $sql2 = str_replace('mdl_', $CFG->prefix, $sql2);

    $cumplimientos = $DB->get_records_sql($sql2);
    $columnas = 5;
    foreach ($cumplimientos as $cumplimiento) {
        $status = "";
        if($cumplimiento->value >= 1){
            $status = $txt_present;
        }
        else{
            $status = $txt_nopresent;
        }
        $hoja->write_string($row,$columnas, $status);
        $columnas++;
    }


    /* CALIFICACIONES */
    $sql3 = "SELECT * 
            FROM 
                mdl_trackerclass_reportes 
            WHERE 
                userid = {$dedicacion->userid} AND
                id_programacion = {$id_programacion} AND
                type = 'grade'";

    $sql3 = str_replace('mdl_', $CFG->prefix, $sql3);

    $calificaciones = $DB->get_records_sql($sql3);
    foreach ($calificaciones as $calificacion) {
        $value = 0;
        if ($calificacion->value == null) {
            $value = 0;
        }
        else{
            $value = round((float)$calificacion->value,1);
        }
        $hoja->write_string($row,$columnas, $value);
        $columnas++;
    }

	$row++;
	$n++;
}

$ExcelBook->close();



/* FUNCIONES */
function format_dedication($totalsecs){
    $totalsecs = abs($totalsecs);

    $str = new stdClass();
    $str->hour = get_string('hour');
    $str->hours = get_string('hours');
    $str->min = get_string('min');
    $str->mins = get_string('mins');
    $str->sec = get_string('sec');
    $str->secs = get_string('secs');

    $hours = floor($totalsecs / HOURSECS);
    $remainder = $totalsecs - ($hours * HOURSECS);
    $mins = floor($remainder / MINSECS);
    $secs = round($remainder - ($mins * MINSECS), 2);

    $ss = ($secs == 1) ? $str->sec : $str->secs;
    $sm = ($mins == 1) ? $str->min : $str->mins;
    $sh = ($hours == 1) ? $str->hour : $str->hours;

    $ohours = '';
    $omins = '';
    $osecs = '';

    if ($hours) {
        $ohours = $hours . ' ' . $sh;
    }
    if ($mins) {
        $omins = $mins . ' ' . $sm;
    }
    if ($secs) {
        $osecs = $secs . ' ' . $ss;
    }

    if ($hours) {
        return trim($ohours . ' ' . $omins);
    }
    if ($mins) {
        return trim($omins . ' ' . $osecs);
    }
    if ($secs) {
        return $osecs;
    }
    return get_string('none');
}