<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package     block_trackerclass
 * @copyright   2019 Jose Gomez <info@escueladidactica.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/*
* Esta clase se encarga de renderizar formulario del bloque,
* hacer validaciones y consultas necesarias para el buen
* funcionamiento de la solucion "ver Certificados".
*/
require_once("../../../config.php");
require_once($CFG->libdir . '/excellib.class.php'); //Libreria de excel

global $PAGE, $CFG;

$course_id = $_REQUEST['courseid'];

$title_username = get_string('label_header_identification', 'block_trackerclass');
$title_fullname = get_string('label_header_fullname', 'block_trackerclass');
$title_sms = get_string('label_type_sms_tracking', 'block_trackerclass');
$title_email = get_string('label_type_email_tracking', 'block_trackerclass');
$title_call = get_string('label_type_call_tracking', 'block_trackerclass');

$name_seguimiento = get_string('btn_register', 'block_trackerclass');

$course = $DB->get_record('course',['id'=>$course_id]);
$today = date("Y-m-d");
$downloadfilename = clean_filename("Seguimiento - ".$today."_".$course->fullname); //Nombre del archivo .xls
$ExcelBook = new MoodleExcelWorkbook("-");
$ExcelBook->send($downloadfilename);


/*
* REGISTRAR SEGUIMIENTO
*/
$worksheet_dedicacion = $ExcelBook->add_worksheet($name_seguimiento);
$worksheet_dedicacion->write_string(0,0,$name_seguimiento);
$worksheet_dedicacion->write_string(1,1,"N°");
$worksheet_dedicacion->write_string(1,2,$title_username); //username
$worksheet_dedicacion->write_string(1,3,$title_fullname); //fullname
$worksheet_dedicacion->write_string(1,4,$title_sms); //sms
$worksheet_dedicacion->write_string(1,5,$title_email); //email
$worksheet_dedicacion->write_string(1,6,$title_call); //call


$sql1 = "SELECT u.id as userid, u.username, u.firstname, u.lastname, r.shortname
            FROM mdl_user u
            JOIN mdl_role_assignments s on(u.id= s.userid)
            JOIN mdl_role r on(r.id=s.roleid)
            JOIN mdl_context ct on (ct.id=s.contextid AND ct.contextlevel=50)
            JOIN mdl_course c ON(c.id=ct.instanceid) 
            WHERE c.id={$course_id}";

$sql1 = str_replace('mdl_', $CFG->prefix, $sql1);

$students = $DB->get_records_sql($sql1);

$row = 2;
$i = 1;
foreach ($students as $key => $student) {
    $userid = $student->userid;
    $username = $student->username;
    $fullname = $student->firstname.' '.$student->lastname;
    $worksheet_dedicacion->write_string($row,1,$i);
    $worksheet_dedicacion->write_string($row,2,$username); //username
    $worksheet_dedicacion->write_string($row,3,$fullname); //fullname


    $sql2 = "SELECT userid,
                COUNT(IF(type = 'sms' , type, NULL)) as 'sms',
                COUNT(IF(type = 'call' , type, NULL)) as 'call',
                COUNT(IF(type = 'email' , type, NULL)) as 'email'
            FROM `mdl_trackerclass_seguimiento`
            WHERE userid = {$userid}";

    $sql2 = str_replace('mdl_', $CFG->prefix, $sql2);
    $counts = $DB->get_records_sql($sql2);

    foreach ($counts as $key2 => $count) {
        $sms = $count->sms;
        $call = $count->call;
        $email = $count->email;

        $worksheet_dedicacion->write_string($row,4,$sms); //sms
        $worksheet_dedicacion->write_string($row,5,$email); //email
        $worksheet_dedicacion->write_string($row,6,$call); //call
    }

    $row++;
    $i++;
}

$ExcelBook->close();

