<?php

require_once('../../../config.php');


//variables globales
global $CFG, $USER, $DB;

$id_programacion = $_REQUEST['id_programacion'];
$type = $_REQUEST['type'];

//Objeto de respuesta del API
$arrayRespuesta=array(
	'estado'=>'0',
	'mensaje'=>'Transaccion exitosa',
	'data'=>$_REQUEST
);

function format_dedication($totalsecs){
    $totalsecs = abs($totalsecs);

    $str = new stdClass();
    $str->hour = get_string('hour');
    $str->hours = get_string('hours');
    $str->min = get_string('min');
    $str->mins = get_string('mins');
    $str->sec = get_string('sec');
    $str->secs = get_string('secs');

    $hours = floor($totalsecs / HOURSECS);
    $remainder = $totalsecs - ($hours * HOURSECS);
    $mins = floor($remainder / MINSECS);
    $secs = round($remainder - ($mins * MINSECS), 2);

    $ss = ($secs == 1) ? $str->sec : $str->secs;
    $sm = ($mins == 1) ? $str->min : $str->mins;
    $sh = ($hours == 1) ? $str->hour : $str->hours;

    $ohours = '';
    $omins = '';
    $osecs = '';

    if ($hours) {
        $ohours = $hours . ' ' . $sh;
    }
    if ($mins) {
        $omins = $mins . ' ' . $sm;
    }
    if ($secs) {
        $osecs = $secs . ' ' . $ss;
    }

    if ($hours) {
        return trim($ohours . ' ' . $omins);
    }
    if ($mins) {
        return trim($omins . ' ' . $osecs);
    }
    if ($secs) {
        return $osecs;
    }
    return get_string('none');
}

if(isloggedin()) {
    if($_SERVER['REQUEST_METHOD'] === 'POST') {
        try {

            $sql = "SELECT *
                    FROM mdl_trackerclass_reportes
                    WHERE id_programacion = ".$id_programacion."
                        AND type = '".$type."'";

            $sql = str_replace('mdl_', $CFG->prefix, $sql);

            $results = $DB->get_records_sql($sql);
            $arrayReportes = array();
            $index = 1;

            foreach ($results as $key => $res) {
                $datos = new stdClass();
                $datos->id = $res->id;
                $datos->id_programacion = $res->id_programacion;
                $datos->itemname = $res->itemname;
                $datos->value = $res->value;
                $datos->userid = $res->userid;
                $datos->courseid = $res->courseid;
                $datos->date = date("Y-m-d", $res->date);
                $datos->sortorder = $res->sortorder;
                $datos->type = $res->type;
                $datos->dedication = format_dedication($res->value);
                $datos->dedication_int = $res->value;

                $user = $DB->get_record("user", ['id'=>$res->userid]);

                if(!empty($user)){
                    $datos->index = $index;
                    $datos->firstname = $user->firstname;
                    $datos->lastname = $user->lastname;
                    $datos->fullname = $user->firstname." ".$user->lastname;
                    $datos->username = $user->username;
                }
                $index++;

                array_push($arrayReportes, $datos);
            }

            $arrayRespuesta = array(
                'estado'=>'1',
                'mensaje'=>'consulta realizada',
                'data'=> $arrayReportes
            ); 

        }catch(Exception $e) {
            echo "Exception";
            //var_dump($e);
            $arrayRespuesta = array(
                'estado' => '-1',
                'mensaje' => $e->getMessage(),
                'data' => $_REQUEST
            );
        }
    }
    else{
        $arrayRespuesta=array(
            'estado'=>'-2',
            'mensaje'=>'Metodo request incorrecto',
            'data'=>$_REQUEST
        );
    }
}
echo json_encode($arrayRespuesta);
?>
