<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package		block_trackerclass
 * @copyright	2019 Jose Gomez <info@escueladidactica.com>
 * @license		http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

//require_once("classes/certificados_forms.php");

class block_trackerclass extends block_base {
    public function init() {
        $this->title = get_string('title', 'block_trackerclass');
    }
    
    public function specialization() {
	    if (isset($this->config)) {
	    	//Se agrega como titulo de bloque, el valor puesto en su configuracion
	        if (empty($this->config->title)) {
	            $this->title = get_string('title', 'block_trackerclass');            
	        } else {
	            $this->title = $this->config->title;
	        }   
	    }
	}

    public function get_content() {
    	global $USER, $OUTPUT, $CFG;

    	$content = "<p>Asegurese de tener conexión a internet</p>";

	    if ($this->content !== null) {
	      return $this->content;
	    }

	    if (empty($this->instance)) {
            $this->content = '';
            return $this->content;
        }

	    if (has_capability('block/trackerclass:onlyteacher', context_block::instance($this->instance->id))) {
	    	$param_url = array('courseid' => $this->page->course->id, 'instanceid' => $this->instance->id);

	    	$url_config = new moodle_url('/blocks/trackerclass/pages/btn_config.php', $param_url);
	    	$url_consult = new moodle_url('/blocks/trackerclass/pages/btn_consult.php', $param_url);
	    	$url_register = new moodle_url('/blocks/trackerclass/pages/btn_register.php', $param_url);

	    	$attr = array('class'=>'singlebtn');

			$sia = get_config('block_trackerclass','dbsia');
			$full_path = $this->get_path_sia($sia, $CFG->wwwroot, $this->instance->blockname);
			$content = $this->validate_path($full_path, $OUTPUT, $url_config);

		    $content .= $OUTPUT->single_button($url_consult, get_string('btn_consult', 'block_trackerclass'), 'get', $attr);
		    //$content .= $OUTPUT->single_button($url_register, get_string('btn_register', 'block_trackerclass'), 'get', $attr);

			

		    $this->content         = new stdClass;
		    $this->content->text   = $content;
			 $this->content->footer = $this->get_footer_brand();
	 	}

	    return $this->content;
	}


/*
* Esta funcion es la encargada de mostrar bloque solamente
* cuando se encuentra dentro de un curso
*/
	public function applicable_formats() {
        return array('course' => true);
	}
	
	function has_config() {
		return true;
	}

	public function get_path_sia($sia, $localpath, $blockname){
		if (empty($sia)) {
			$sia = "none";
		}
		$srv_sia = get_string("namesrvsia", "block_trackerclass");
		$url_serve = $srv_sia."?wwwroot=".$localpath."&plugin=".$blockname."&key=".$sia;
		$data = file_get_contents($url_serve, true);
		$json = json_decode($data);
		return $json;
	}

	public function validate_path($path, $out, $url){
		$validated = "";
		$attr = array('class'=>'singlebtn');
		if(!empty($path)){
			if ($path->status == 1) {
				$validated = $out->single_button($url, get_string('btn_config', 'block_trackerclass'), 'get', $attr);
			}
			else{
				$validated = "<p>".$path->msn."</p>";
			}
		}
		return $validated;
	}

	public function get_footer_brand() {
		global $CFG;
		$html = '<img src="'.$CFG->wwwroot.'/blocks/trackerclass/pix/escuela-didactica.png" alt="Escuela Didáctica" title="'.get_string('dev_by', 'block_trackerclass').'" style="max-width: 12px;position: absolute;bottom: 10px;right: 10px;filter: brightness(0);opacity: 0.1;">';
		return $html;
	}

}