<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package     block_trackerclass
 * @copyright   2019 Jose Gomez <info@escueladidactica.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/*
* Esta clase se encarga de renderizar formulario del bloque,
* hacer validaciones y consultas necesarias para el buen
* funcionamiento de la solucion "ver Certificados".
*/
require_once("$CFG->libdir/formslib.php");
require_once("$CFG->libdir/adminlib.php");

//defined('MOODLE_INTERNAL') || die();

class renderer_pages implements renderable {

/*
* Funcion que renderiza y setea la primera parte de las paginas
* asignando contexto header y titulos de pagina con api de moodle.
*/
    public function render_header($path, $title, $navbar = false){
        global $PAGE, $OUTPUT, $DB;

        $courseid = required_param('courseid', PARAM_INT);
        $instanceid = required_param('instanceid', PARAM_INT);
        $action = optional_param('action', 'all', PARAM_ALPHANUM);
        $id = optional_param('id', 0, PARAM_INT);
        $context = context_block::instance($instanceid);

        $course = $DB->get_record("course", array("id" => $courseid), '*', MUST_EXIST);
        require_course_login($course);

        $url = new moodle_url('/blocks/trackerclass/pages/'.$path.'.php', array('courseid' => $courseid, 'instanceid' => $instanceid));

        $pageurl = new moodle_url('/blocks/trackerclass/pages/'.$path.'.php');
        $pageurl->params(array(
            'courseid' => $courseid,
            'instanceid' => $instanceid,
            'action' => $action,
            'id' => $id,
        ));

        $PAGE->set_context($context);
        $PAGE->set_pagelayout('report');
        $PAGE->set_pagetype('course-view-' . $course->format);
        if ($navbar) {
            $PAGE->navbar->add($title, $navbar);
        }
        else{
            $PAGE->navbar->add($title, $url);
        }        

        $PAGE->set_url($pageurl);

        $PAGE->set_title($title);
        $PAGE->set_heading($title);

        return $OUTPUT->header();
    }


/*
* Funcion que renderiza el footer de las paginas
* asignando footer de pagina con api de moodle.
*/
    public function render_footer(){
    	global $OUTPUT;
        return $OUTPUT->footer();
    }
}