<?php

namespace block_trackerclass\task;
require_once(dirname(__DIR__)."/../../../blocks/dedication/dedication_lib.php");

//defined('MOODLE_INTERNAL') || die();
/**
 * An example of a scheduled task.
 */
class execute_programacion_reports extends \core\task\scheduled_task {
 
    /**
     * Return the task's name as shown in admin screens.
     *
     * @return string
     */
    public function get_name() {
        return get_string('execute_programation_reports', 'block_trackerclass');
    }
 
    /**
     * Execute the task.
     */
    public function execute() {

        //----------------------------
        global $DB, $CFG;

        $today = strtotime(date("Y-m-d"));
        $today_time = strtotime(date("H:i"));

        $sql = "SELECT * 
                FROM mdl_trackerclass_programacion tp 
                WHERE 
                    tp.date = ".$today."
                    AND tp.time = ".$today_time;

        $sql = str_replace('mdl_', $CFG->prefix, $sql);

        $tasks = $DB->get_records_sql($sql);

        if(!empty($tasks)){
            foreach ($tasks as $key => $task) { // TAREA PROGRAMADA

                $course = $DB->get_record("course", array("id" => $task->courseid), '*', MUST_EXIST);
                $mintime = optional_param('mintime', $course->startdate, PARAM_INT);
                $maxtime = optional_param('maxtime', time(), PARAM_INT);

                $sql1 = "SELECT i.id, m.id as id_modulo,m.name as modulo,i.iteminstance as id_actividad, i.itemtype as tipo, i.sortorder
                        FROM mdl_grade_items i
                        JOIN mdl_modules m ON(i.itemmodule=m.name)
                        JOIN mdl_course c ON(i.courseid = c.id)
                        WHERE c.id=".$task->courseid."
                        ORDER BY i.sortorder";

                        $sql1 = str_replace('mdl_', $CFG->prefix, $sql1);

                $activities_grade_book = $DB->get_records_sql($sql1);


                $sql2 = "SELECT u.id as userid, u.firstname, u.lastname, u.email, r.shortname as role
                        FROM mdl_user u
                        JOIN mdl_role_assignments s on(u.id= s.userid)
                        JOIN mdl_role r on(r.id=s.roleid)
                        JOIN mdl_context ct on (ct.id=s.contextid AND ct.contextlevel=50)
                        JOIN mdl_course c ON(c.id=ct.instanceid) 
                        WHERE c.id=".$task->courseid."
                            AND r.id = 5";

                        $sql2 = str_replace('mdl_', $CFG->prefix, $sql2);

                $students = $DB->get_records_sql($sql2);

                if(!empty($activities_grade_book) && !empty($students)){

                    foreach ($activities_grade_book as $key1 => $activity_grade_book) { // ACTIVIDADES EN LIBRO DE CALIFICACIONES

                        foreach ($students as $key2 => $student) { // ESTUDIANTES MATRICULADOS EN EL CURSO
                        
                            $sql3 = "SELECT gr.id, gr.finalgrade as nota, m.name
                                FROM  mdl_grade_items i
                                LEFT JOIN  mdl_grade_grades gr ON (i.id =gr.itemid)
                                LEFT JOIN  mdl_".$activity_grade_book->modulo." m ON(m.id=i.iteminstance)
                                WHERE i.courseid=".$task->courseid."
                                AND i.iteminstance=".$activity_grade_book->id_actividad."
                                AND i.itemmodule='".$activity_grade_book->modulo."'
                                AND i.itemtype='mod'
                                AND gr.userid=".$student->userid."";

                                $sql3 = str_replace('mdl_', $CFG->prefix, $sql3);


                            $module_grade = $DB->get_records_sql($sql3);


                            $sql5 = "SELECT COUNT(*) as estado, m.name 
                                    FROM  mdl_logstore_standard_log l
                                    JOIN  mdl_course_modules cm ON (l.contextinstanceid =cm .id)
                                    JOIN  mdl_".$activity_grade_book->modulo." m ON(m.id=cm.instance)
                                    WHERE l.courseid=".$task->courseid."
                                    AND l.action in ('created','submitted','sent','added','uploaded', 'updated')
                                    AND l.component='mod_".$activity_grade_book->modulo."'
                                    AND m.id=".$activity_grade_book->id_actividad." 
                                    AND l.userid=".$student->userid."";

                                    $sql5 = str_replace('mdl_', $CFG->prefix, $sql5);

                            $activity_status = $DB->get_records_sql($sql5);

                            
                            $reports = new \stdClass();

                            if(!empty($module_grade)){
                                $reports->module_grade = new \stdClass();
                                foreach ($module_grade as $key3 => $module) {
                                    if (is_null($module->nota)) {
                                        $module->nota = "0";
                                    }
                                    $reports->module_grade->itemname = $module->name;
                                    $reports->module_grade->value = $module->nota;
                                    $reports->module_grade->userid = intval($student->userid);
                                    $reports->module_grade->courseid = intval($task->courseid);
                                    $reports->module_grade->id_programacion = intval($task->id);
                                    $reports->module_grade->date = intval($today);
                                    $reports->module_grade->sortorder = intval($activity_grade_book->sortorder);
                                    $reports->module_grade->type = "grade";
                                }
                                $inserted_module = $DB->insert_record("trackerclass_reportes", $reports->module_grade);
                            }

                            if(!empty($activity_status)){
                                $reports->status = new \stdClass();
                                foreach ($activity_status as $key5 => $status) {
                                    $reports->status->itemname = $status->name;
                                    $reports->status->value = $status->estado;
                                    $reports->status->userid = intval($student->userid);
                                    $reports->status->courseid = intval($task->courseid);
                                    $reports->status->id_programacion = intval($task->id);
                                    $reports->status->date = intval($today);
                                    $reports->status->sortorder = intval($activity_grade_book->sortorder);
                                    $reports->status->type = "status";
                                }
                                $inserted_status = $DB->insert_record("trackerclass_reportes", $reports->status);
                            }
                            
                        }
                    }


                    foreach ($students as $key6 => $student) {

                        $sql4 = "SELECT gr.id, gr.finalgrade as nota 
                                FROM  mdl_grade_items i
                                JOIN  mdl_grade_grades gr ON (i.id =gr.itemid)
                                WHERE i.courseid=".$task->courseid."
                                AND i.itemtype='course'
                                AND gr.userid=".$student->userid."";

                                $sql4 = str_replace('mdl_', $CFG->prefix, $sql4);

                        $final_grade = $DB->get_records_sql($sql4);

                        if(!empty($final_grade)){
                            $reports->final_grade = new \stdClass();
                            foreach ($final_grade as $key4 => $final) {
                                if (is_null($final->nota)) {
                                    $final->nota = "0";
                                }
                                $reports->final_grade->itemname = "final grade";
                                $reports->final_grade->value = $final->nota;
                                $reports->final_grade->userid = intval($student->userid);
                                $reports->final_grade->courseid = intval($task->courseid);
                                $reports->final_grade->id_programacion = intval($task->id);
                                $reports->final_grade->date = intval($today);
                                $reports->final_grade->sortorder = 100000000;
                                $reports->final_grade->type = "grade";
                            }
                            $inserted_final = $DB->insert_record("trackerclass_reportes", $reports->final_grade);
                        }


                        $dm = new \block_dedication_manager($course, $mintime, $maxtime, BLOCK_DEDICATION_DEFAULT_SESSION_LIMIT);
                        $user = $DB->get_record('user', array('id' => $student->userid), '*', MUST_EXIST);
                        $rows = $dm->get_user_dedication($user);
                        $totaldedication = 0;
                        foreach ($rows as $index => $row) {
                            $totaldedication += $row->dedicationtime;
                        }

                        $reports->dedication = new \stdClass();
                        $reports->dedication->itemname = "dedication";
                        $reports->dedication->value = $totaldedication;
                        $reports->dedication->userid = intval($student->userid);
                        $reports->dedication->courseid = intval($task->courseid);
                        $reports->dedication->id_programacion = intval($task->id);
                        $reports->dedication->date = intval($today);
                        $reports->dedication->sortorder = 10000000;
                        $reports->dedication->type = "dedication";

                        $inserted_dedication = $DB->insert_record("trackerclass_reportes", $reports->dedication);

                    }
                }
            }
        }
        //----------------------------
    }
}