<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package		block_trackerclass
 * @copyright	2019 Jose Gomez <info@escueladidactica.com>
 * @license		http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once("../../../config.php");
require_once("../classes/pages.php"); //Clases que renderizan pagina donde se mostraran los resultados
require_once($CFG->dirroot . '/lib/mustache/src/Mustache/Autoloader.php'); //Clases para renderizar mustache


$print = new renderer_pages();

$path = basename($_SERVER['PHP_SELF'], ".php");
$page_title = get_string($path, 'block_trackerclass');


echo $print->render_header($path, $page_title);

	Mustache_Autoloader::register();
	$css = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/css/')));
	$html = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/html/')));
	$js = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/js/')));

	$courseid = required_param('courseid', PARAM_INT);
	$date = date("D M d Y H:i:s");
	$GMT = date("O");
	$date_today = $date." GMT".$GMT;

	$datos_html = [
		'txt_date'=> get_string('label_date', 'block_trackerclass'),
		'txt_time'=> get_string('label_time', 'block_trackerclass'),
		'txt_basic'=> get_string('label_basic', 'block_trackerclass'),
		'txt_advance'=> get_string('label_advance', 'block_trackerclass'),
		'txt_from'=> get_string('label_from', 'block_trackerclass'),
		'txt_to'=> get_string('label_to', 'block_trackerclass'),
		'txt_repeat'=> get_string('label_repeat', 'block_trackerclass'),
		'txt_choice'=> get_string('label_choice', 'block_trackerclass'),
		'txt_every_day'=> get_string('label_every_day', 'block_trackerclass'),
		'txt_every_week'=> get_string('label_every_week', 'block_trackerclass'),
		'txt_every_month'=> get_string('label_every_month', 'block_trackerclass'),
		'txt_monday'=> get_string('label_monday', 'block_trackerclass'),
		'txt_tuesday'=> get_string('label_tuesday', 'block_trackerclass'),
		'txt_wednesday'=> get_string('label_wednesday', 'block_trackerclass'),
		'txt_thursday'=> get_string('label_thursday', 'block_trackerclass'),
		'txt_friday'=> get_string('label_friday', 'block_trackerclass'),
		'txt_saturday'=> get_string('label_saturday', 'block_trackerclass'),
		'txt_sunday'=> get_string('label_sunday', 'block_trackerclass'),
		'txt_day'=> get_string('label_day', 'block_trackerclass'),
		'txt_add'=> get_string('label_add', 'block_trackerclass'),
		'txt_advice'=> get_string('label_advice', 'block_trackerclass'),
	];
	$datos_js = [
		'courseid'=>$courseid,
		'txt_error_empty'=> get_string('label_error_empty', 'block_trackerclass'),
		'txt_error_api'=> get_string('label_error_api', 'block_trackerclass'),
		'txt_error_date'=> get_string('label_error_date', 'block_trackerclass'),
		'txt_error_every_week'=> get_string('label_error_every_week', 'block_trackerclass'),
		'txt_error_every_month'=> get_string('label_error_every_month', 'block_trackerclass'),
	];

	echo $css->render($path);
	echo $html->render($path,$datos_html);
	echo $js->render($path, $datos_js);

echo $print->render_footer();