<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package		block_trackerclass
 * @copyright	2019 Jose Gomez <info@escueladidactica.com>
 * @license		http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once("../../../config.php");
require_once("../classes/pages.php");
require_once($CFG->dirroot . '/lib/mustache/src/Mustache/Autoloader.php'); //Clases para renderizar mustache


$print = new renderer_pages();

$path = basename($_SERVER['PHP_SELF'], ".php");
$page_title = get_string($path, 'block_trackerclass');


echo $print->render_header($path, $page_title);

	Mustache_Autoloader::register();
	$css = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/css/')));
	$html = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/html/')));
	$js = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/js/')));
	

	$courseid = required_param('courseid', PARAM_INT);
	$instanceid = required_param('instanceid', PARAM_INT);

	$url_consult_chart = new moodle_url('/blocks/trackerclass/pages/btn_consult_chart.php');

	$datos_html = [
		'txt_date'=> get_string('label_date', 'block_trackerclass'),
		'txt_action'=> get_string('label_action', 'block_trackerclass'),
	];
	$datos_js = [
		'courseid' => $courseid,
		'instanceid' => $instanceid,
		'path_consult_chart' => $url_consult_chart,
		'txt_error_api'=> get_string('label_error_api', 'block_trackerclass'),
		'txt_view'=> get_string('label_view', 'block_trackerclass'),
	];

	echo $css->render($path);
	echo $html->render($path,$datos_html);
	echo $js->render($path, $datos_js);

echo $print->render_footer();