<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package		block_trackerclass
 * @copyright	2019 Jose Gomez <info@escueladidactica.com>
 * @license		http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once("../../../config.php");
require_once("../classes/pages.php");
require_once($CFG->dirroot . '/lib/mustache/src/Mustache/Autoloader.php'); //Clases para renderizar mustache


$print = new renderer_pages();

$path = basename($_SERVER['PHP_SELF'], ".php");
$page_title = get_string($path, 'block_trackerclass');

$courseid = required_param('courseid', PARAM_INT);
$instanceid = required_param('instanceid', PARAM_INT);
$id_programacion = required_param('id_programacion', PARAM_INT);

$params_navbar = [
	'courseid' => $courseid,
	'instanceid' => $instanceid,
	'id_programacion' => $id_programacion,
];

$url_navbar = new moodle_url('/blocks/trackerclass/pages/btn_consult_chart.php', $params_navbar);
$url_download_reports = new moodle_url('/blocks/trackerclass/api/export_to_excel.php?courseid='.$courseid.'&id_programacion='.$id_programacion);
$url_download_reports = str_replace("&amp;", "$$$", $url_download_reports);

echo $print->render_header($path, $page_title, $url_navbar);

	Mustache_Autoloader::register();
	$css = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/css/')));
	$html = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/html/')));
	$js = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/js/')));
	
	$datos_html = [
		'txt_error_api'=> get_string('label_error_api', 'block_trackerclass'),
		'txt_btn_dedicacion'=> get_string('label_btn_dedicacion', 'block_trackerclass'),
		'txt_btn_cumplimiento'=> get_string('label_btn_cumplimiento', 'block_trackerclass'),
		'txt_btn_calificacion'=> get_string('label_btn_calificacion', 'block_trackerclass'),
		'txt_btn_regresar'=> get_string('label_btn_regresar', 'block_trackerclass'),
		'txt_header_identification'=> get_string('label_header_identification', 'block_trackerclass'),
		'txt_header_fullname'=> get_string('label_header_fullname', 'block_trackerclass'),
		'txt_header_dedication'=> get_string('label_header_dedication', 'block_trackerclass'),
		'txt_summary_dedication'=> get_string('label_summary_dedication', 'block_trackerclass'),
		'txt_summary_dedication_total'=> get_string('label_summary_dedication_total', 'block_trackerclass'),
		'txt_summary_dedication_prom'=> get_string('label_summary_dedication_prom', 'block_trackerclass'),
		'txt_summary_dedication_cant'=> get_string('label_summary_dedication_cant', 'block_trackerclass'),
		'txt_input_search'=> get_string('label_input_search', 'block_trackerclass'),
	];
	$datos_js = [
		'id_programacion' => $id_programacion,
		'url_download_reports'=> $url_download_reports,
		'txt_error_api'=> get_string('label_error_api', 'block_trackerclass'),
		'txt_error_datatable'=> get_string('label_error_datatable', 'block_trackerclass'),
		'txt_header_identification'=> get_string('label_header_identification', 'block_trackerclass'),
		'txt_header_fullname'=> get_string('label_header_fullname', 'block_trackerclass'),
		'txt_header_dedication'=> get_string('label_header_dedication', 'block_trackerclass'),
		'txt_table_present'=> get_string('label_table_present', 'block_trackerclass'),
		'txt_table_nopresent'=> get_string('label_table_nopresent', 'block_trackerclass'),
		'txt_table_finalgrade'=> get_string('label_table_finalgrade', 'block_trackerclass'),
		'txt_chart_none'=> get_string('label_chart_none', 'block_trackerclass'),
		'txt_chart_hours'=> get_string('label_chart_hours', 'block_trackerclass'),
		'txt_chart_hoursmore'=> get_string('label_chart_hoursmore', 'block_trackerclass'),
		'txt_chart_activities'=> get_string('label_chart_activities', 'block_trackerclass'),
		'txt_chart_average'=> get_string('label_chart_average', 'block_trackerclass'),
		'txt_title_chart_dedication'=> get_string('label_title_chart_dedication', 'block_trackerclass'),
		'txt_title_chart_compliance_1'=> get_string('label_title_chart_compliance_1', 'block_trackerclass'),
		'txt_title_chart_compliance_2'=> get_string('label_title_chart_compliance_2', 'block_trackerclass'),
		'txt_title_chart_grade_1'=> get_string('label_title_chart_grade_1', 'block_trackerclass'),
		'txt_title_chart_grade_2'=> get_string('label_title_chart_grade_2', 'block_trackerclass'),
		'txt_btn_download_chart'=> get_string('label_btn_download_chart', 'block_trackerclass'),
		'txt_btn_reload' => get_string('label_btn_reload', 'block_trackerclass'),
		'txt_hour' => get_string('hour'),
	    'txt_hours' => get_string('hours'),
	    'txt_min' => get_string('min'),
	    'txt_mins' => get_string('mins'),
	    'txt_sec' => get_string('sec'),
	    'txt_secs' => get_string('secs'),
	    'txt_none' => get_string('none'),
	];

	echo $css->render($path);
	echo $html->render($path,$datos_html);
	echo $js->render($path, $datos_js);

echo $print->render_footer();
