<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package		block_trackerclass
 * @copyright	2019 Jose Gomez <info@escueladidactica.com>
 * @license		http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once("../../../config.php");
require_once("../classes/pages.php");
require_once($CFG->dirroot . '/lib/mustache/src/Mustache/Autoloader.php');

$print = new renderer_pages();

$path = basename($_SERVER['PHP_SELF'], ".php");
$page_title = get_string($path, 'block_trackerclass');

$courseid = required_param('courseid', PARAM_INT);
$instanceid = required_param('instanceid', PARAM_INT);

$url_download_reports = new moodle_url('/blocks/trackerclass/api/export_to_excel_tracking.php?courseid='.$courseid);
$url_download_reports = str_replace("&amp;", "$$$", $url_download_reports);

echo $print->render_header($path, $page_title);


	Mustache_Autoloader::register();
	$css = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/css/')));
	$html = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/html/')));
	$js = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/js/')));

	$url_register_details = new moodle_url('/blocks/trackerclass/pages/btn_register_details.php');

	$datos_html = [
		'page_title'=>$page_title,
		'txt_header_identification'=> get_string('label_header_identification', 'block_trackerclass'),
		'txt_header_fullname'=> get_string('label_header_fullname', 'block_trackerclass'),
		'txt_header_quantities'=> get_string('label_header_quantities', 'block_trackerclass'),
		'txt_loading'=> get_string('label_loading', 'block_trackerclass'),
		'txt_btn_add_tracking'=> get_string('label_btn_add_tracking', 'block_trackerclass'),
		'txt_title_new_tracking'=> get_string('label_title_new_tracking', 'block_trackerclass'),
		'txt_title_date_tracking'=> get_string('label_title_date_tracking', 'block_trackerclass'),
		'txt_type_tracking'=> get_string('label_type_tracking', 'block_trackerclass'),
		'txt_type_sms_tracking'=> get_string('label_type_sms_tracking', 'block_trackerclass'),
		'txt_type_email_tracking'=> get_string('label_type_email_tracking', 'block_trackerclass'),
		'txt_type_call_tracking'=> get_string('label_type_call_tracking', 'block_trackerclass'),
		'txt_title_observation'=> get_string('label_title_observation', 'block_trackerclass'),
		'txt_btn_save'=> get_string('label_btn_save', 'block_trackerclass'),
		'txt_btn_cancel'=> get_string('label_btn_cancel', 'block_trackerclass'),
	];

	$datos_js = [
		'courseid' => $courseid,
		'instanceid' => $instanceid,
		'path_register_details' => $url_register_details,
		'url_download_reports'=> $url_download_reports,
		'txt_type_sms_tracking'=> get_string('label_type_sms_tracking', 'block_trackerclass'),
		'txt_type_email_tracking'=> get_string('label_type_email_tracking', 'block_trackerclass'),
		'txt_type_call_tracking'=> get_string('label_type_call_tracking', 'block_trackerclass'),
		'txt_see_tracking'=> get_string('label_see_tracking', 'block_trackerclass'),
		'txt_success_modal_add_tracking'=> get_string('label_success_modal_add_tracking', 'block_trackerclass'),
		'txt_error_modal_add_tracking'=> get_string('label_error_modal_add_tracking', 'block_trackerclass'),
		'txt_error_modal_all_required'=> get_string('label_error_modal_all_required', 'block_trackerclass'),
		'txt_error_empty_results_get_students'=> get_string('label_error_empty_results_get_students', 'block_trackerclass'),
		'txt_error_empty_results_get_cantidades'=> get_string('label_error_empty_results_get_cantidades', 'block_trackerclass'),
		'txt_error_any_student'=> get_string('label_error_any_student', 'block_trackerclass'),
	];

	echo $css->render($path);
	echo $html->render($path,$datos_html);
	echo $js->render($path, $datos_js);


echo $print->render_footer();