<?php
// Este codigo le pertenece a Escuela Didactica <https://escueladidactica.com>
//
// Construimos procesos de transformación para empresas donde sus 
// colaboradores se capaciten con el conocimiento de su empresa 
// mediante experiencias educativas digitales.
//

/**
 *
 * @package		block_trackerclass
 * @copyright	2019 Jose Gomez <info@escueladidactica.com>
 * @license		http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once("../../../config.php");
require_once("../classes/pages.php");
require_once($CFG->dirroot . '/lib/mustache/src/Mustache/Autoloader.php'); //Clases para renderizar mustache


$print = new renderer_pages();

$path = basename($_SERVER['PHP_SELF'], ".php");
$page_title = get_string($path, 'block_trackerclass');

$courseid = required_param('courseid', PARAM_INT);
$instanceid = required_param('instanceid', PARAM_INT);
$userid = required_param('userid', PARAM_INT);

$params_navbar = [
	'courseid' => $courseid,
	'instanceid' => $instanceid,
	'userid' => $userid,
];

$url_navbar = new moodle_url('/blocks/trackerclass/pages/btn_register_details.php', $params_navbar);

echo $print->render_header($path, $page_title, $url_navbar);

	Mustache_Autoloader::register();
	$css = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/css/')));
	$html = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/html/')));
	$js = new Mustache_Engine(array('loader' => new Mustache_Loader_FilesystemLoader('../templates/js/')));
	
	$datos_html = [
		'txt_btn_regresar'=> get_string('label_btn_regresar', 'block_trackerclass'),

		'txt_header_date_tracking'=> get_string('label_header_date_tracking', 'block_trackerclass'),
		'txt_header_date_system'=> get_string('label_header_date_system', 'block_trackerclass'),
		'txt_header_type_tracking'=> get_string('label_header_type_tracking', 'block_trackerclass'),
		'txt_header_observation'=> get_string('label_header_observation', 'block_trackerclass'),
		'txt_header_delete'=> get_string('label_header_delete', 'block_trackerclass'),
		'txt_loading'=> get_string('label_loading', 'block_trackerclass'),
	];
	$datos_js = [
		'userid' => $userid,
		'courseid' => $courseid,
		'txt_type_sms_tracking'=> get_string('label_type_sms_tracking', 'block_trackerclass'),
		'txt_type_email_tracking'=> get_string('label_type_email_tracking', 'block_trackerclass'),
		'txt_type_call_tracking'=> get_string('label_type_call_tracking', 'block_trackerclass'),
		'txt_table_read_more'=> get_string('label_table_read_more', 'block_trackerclass'),
		'txt_table_read_less'=> get_string('label_table_read_less', 'block_trackerclass'),
		'txt_error_empty_results_get_students'=>get_string('label_error_empty_results_get_students', 'block_trackerclass'),
		'txt_error_empty_tracking'=>get_string('label_error_empty_tracking', 'block_trackerclass'),
		'txt_fail_to_deleted'=>get_string('label_fail_to_deleted', 'block_trackerclass'),
	];

	echo $css->render($path);
	echo $html->render($path,$datos_html);
	echo $js->render($path, $datos_js);

echo $print->render_footer();